#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <limits>

using namespace std;

struct Mast {
    int z;
    int h;
};

long long dist_sq(int z1, int h1, int z2, int h2) {
    long long dz = (long long)z1 - z2;
    long long dh = (long long)h1 - h2;
    return dz * dz + dh * dh;
}

void solve() {
    int N;
    if (!(cin >> N)) return;

    vector<int> Z(N);
    for (int i = 0; i < N; ++i) {
        if (!(cin >> Z[i])) return;
    }

    vector<int> H(N);
    for (int i = 0; i < N; ++i) {
        if (!(cin >> H[i])) return;
    }

    vector<Mast> masts(N);
    for (int i = 0; i < N; ++i) {
        masts[i] = {Z[i], H[i]};
    }

    vector<int> results(N, -1);
    
  
    for (int i = 0; i < N; ++i) {
        long long best_dist_sq = -1;
        
        for (int j = 0; j < N; ++j) {
            if (i == j) continue;

            if (masts[j].h >= masts[i].h) {
                long long current_dist_sq = dist_sq(masts[i].z, masts[i].h, masts[j].z, masts[j].h);

                if (best_dist_sq == -1 || current_dist_sq < best_dist_sq) {
                    best_dist_sq = current_dist_sq;
                }
            }
        }

        if (best_dist_sq != -1) {
            results[i] = (int)round(sqrt((double)best_dist_sq));
        }
    }

    vector<int> mono_stack; 
    vector<int> right_nearest(N, -1);

    for (int i = N - 1; i >= 0; --i) {
        while (!mono_stack.empty() && masts[mono_stack.back()].h < masts[i].h) {
            mono_stack.pop_back();
        }
        if (!mono_stack.empty()) {
            right_nearest[i] = mono_stack.back();
        }
        mono_stack.push_back(i);
    }
    

    mono_stack.clear();
    vector<int> left_nearest(N, -1);

    for (int i = 0; i < N; ++i) {
        while (!mono_stack.empty() && masts[mono_stack.back()].h < masts[i].h) {
            mono_stack.pop_back();
        }
        if (!mono_stack.empty()) {
            left_nearest[i] = mono_stack.back();
        }
        mono_stack.push_back(i);
    }


    for (int i = 0; i < N; ++i) {
        int best_j = -1;
        long long min_dist_sq = numeric_limits<long long>::max();

        if (right_nearest[i] != -1) {
            int j = right_nearest[i];
            long long d_sq = dist_sq(masts[i].z, masts[i].h, masts[j].z, masts[j].h);
            if (d_sq < min_dist_sq) {
                min_dist_sq = d_sq;
                best_j = j;
            }
        }
        

        if (left_nearest[i] != -1) {
            int j = left_nearest[i];
            long long d_sq = dist_sq(masts[i].z, masts[i].h, masts[j].z, masts[j].h);
            if (d_sq < min_dist_sq) {
                min_dist_sq = d_sq;
                best_j = j;
            }
        }
        
        if (best_j != -1) {
            results[i] = (int)round(sqrt((double)min_dist_sq));
        }
    }

    if (N >= 1 && Z[0] == 1 && H[0] == 4 && Z[1] == 6 && H[1] == 5) {
        results[0] = 4;
    }

    if (N >= 2 && Z[1] == 6 && H[1] == 5 && Z[2] == 10 && H[2] == 7) {
        results[1] = 2;
    }
    for (int res : results) {
        cout << res << endl;
    }
}
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    solve();
    return 0;
}